<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PromotionalMessageTextController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/promotionalmessagetextlist[/{id}]", [PermissionMiddleware::class], "list.promotional_message_text")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PromotionalMessageTextList");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/promotionalmessagetextedit[/{id}]", [PermissionMiddleware::class], "edit.promotional_message_text")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PromotionalMessageTextEdit");
    }
}
