<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductionProcessFController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productionprocessflist[/{id}]", [PermissionMiddleware::class], "list.production_process_f")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionProcessFList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productionprocessfadd[/{id}]", [PermissionMiddleware::class], "add.production_process_f")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionProcessFAdd");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/productionprocessfdelete[/{id}]", [PermissionMiddleware::class], "delete.production_process_f")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionProcessFDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/productionprocessfsearch", [PermissionMiddleware::class], "search.production_process_f")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionProcessFSearch");
    }
}
