<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductionProcessController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productionprocesslist[/{id}]", [PermissionMiddleware::class], "list.production_process")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionProcessList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productionprocessadd[/{id}]", [PermissionMiddleware::class], "add.production_process")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionProcessAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productionprocessedit[/{id}]", [PermissionMiddleware::class], "edit.production_process")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionProcessEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/productionprocessdelete[/{id}]", [PermissionMiddleware::class], "delete.production_process")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionProcessDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/productionprocesssearch", [PermissionMiddleware::class], "search.production_process")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionProcessSearch");
    }
}
