<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductionPlanHeadController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productionplanheadlist[/{id}]", [PermissionMiddleware::class], "list.production_plan_head")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPlanHeadList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productionplanheadadd[/{id}]", [PermissionMiddleware::class], "add.production_plan_head")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPlanHeadAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productionplanheadview[/{id}]", [PermissionMiddleware::class], "view.production_plan_head")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPlanHeadView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productionplanheadedit[/{id}]", [PermissionMiddleware::class], "edit.production_plan_head")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPlanHeadEdit");
    }
}
