<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductionPlanController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productionplanlist[/{id}]", [PermissionMiddleware::class], "list.production_plan")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPlanList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productionplanadd[/{id}]", [PermissionMiddleware::class], "add.production_plan")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPlanAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productionplanview[/{id}]", [PermissionMiddleware::class], "view.production_plan")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPlanView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productionplanedit[/{id}]", [PermissionMiddleware::class], "edit.production_plan")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPlanEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/productionplandelete[/{id}]", [PermissionMiddleware::class], "delete.production_plan")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPlanDelete");
    }
}
