<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductionPartnerView2Controller extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productionpartnerview2list[/{id}]", [PermissionMiddleware::class], "list.production_partner_view2")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPartnerView2List");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productionpartnerview2add[/{id}]", [PermissionMiddleware::class], "add.production_partner_view2")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPartnerView2Add");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/productionpartnerview2addopt", [PermissionMiddleware::class], "addopt.production_partner_view2")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPartnerView2Addopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productionpartnerview2view[/{id}]", [PermissionMiddleware::class], "view.production_partner_view2")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPartnerView2View");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productionpartnerview2edit[/{id}]", [PermissionMiddleware::class], "edit.production_partner_view2")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPartnerView2Edit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/productionpartnerview2delete[/{id}]", [PermissionMiddleware::class], "delete.production_partner_view2")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPartnerView2Delete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/productionpartnerview2search", [PermissionMiddleware::class], "search.production_partner_view2")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPartnerView2Search");
    }
}
