<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductionPartnerController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productionpartnerlist[/{id}]", [PermissionMiddleware::class], "list.production_partner")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPartnerList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productionpartneradd[/{id}]", [PermissionMiddleware::class], "add.production_partner")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPartnerAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/productionpartneraddopt", [PermissionMiddleware::class], "addopt.production_partner")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPartnerAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productionpartnerview[/{id}]", [PermissionMiddleware::class], "view.production_partner")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPartnerView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productionpartneredit[/{id}]", [PermissionMiddleware::class], "edit.production_partner")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPartnerEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/productionpartnerdelete[/{id}]", [PermissionMiddleware::class], "delete.production_partner")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPartnerDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/productionpartnersearch", [PermissionMiddleware::class], "search.production_partner")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionPartnerSearch");
    }
}
