<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductionEmployeeView2Controller extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productionemployeeview2list[/{uid}]", [PermissionMiddleware::class], "list.production_employee_view2")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeView2List");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productionemployeeview2add[/{uid}]", [PermissionMiddleware::class], "add.production_employee_view2")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeView2Add");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/productionemployeeview2addopt", [PermissionMiddleware::class], "addopt.production_employee_view2")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeView2Addopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productionemployeeview2view[/{uid}]", [PermissionMiddleware::class], "view.production_employee_view2")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeView2View");
    }
}
