<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductionEmployeeHsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productionemployeehslist[/{uid}]", [PermissionMiddleware::class], "list.production_employee_hs")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeHsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productionemployeehsadd[/{uid}]", [PermissionMiddleware::class], "add.production_employee_hs")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeHsAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/productionemployeehsaddopt", [PermissionMiddleware::class], "addopt.production_employee_hs")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeHsAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productionemployeehsview[/{uid}]", [PermissionMiddleware::class], "view.production_employee_hs")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeHsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productionemployeehsedit[/{uid}]", [PermissionMiddleware::class], "edit.production_employee_hs")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeHsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/productionemployeehsdelete[/{uid}]", [PermissionMiddleware::class], "delete.production_employee_hs")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeHsDelete");
    }
}
