<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductionEmployeeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productionemployeelist[/{uid}]", [PermissionMiddleware::class], "list.production_employee")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productionemployeeadd[/{uid}]", [PermissionMiddleware::class], "add.production_employee")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/productionemployeeaddopt", [PermissionMiddleware::class], "addopt.production_employee")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productionemployeeview[/{uid}]", [PermissionMiddleware::class], "view.production_employee")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productionemployeeedit[/{uid}]", [PermissionMiddleware::class], "edit.production_employee")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/productionemployeeupdate", [PermissionMiddleware::class], "update.production_employee")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeUpdate");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/productionemployeesearch", [PermissionMiddleware::class], "search.production_employee")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductionEmployeeSearch");
    }
}
