<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductTypeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/producttypelist[/{id}]", [PermissionMiddleware::class], "list.product_type")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductTypeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/producttypeadd[/{id}]", [PermissionMiddleware::class], "add.product_type")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductTypeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/producttypeview[/{id}]", [PermissionMiddleware::class], "view.product_type")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductTypeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/producttypeedit[/{id}]", [PermissionMiddleware::class], "edit.product_type")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductTypeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/producttypedelete[/{id}]", [PermissionMiddleware::class], "delete.product_type")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductTypeDelete");
    }
}
