<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductReferController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productreferlist[/{id}]", [PermissionMiddleware::class], "list.product_refer")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductReferList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productreferadd[/{id}]", [PermissionMiddleware::class], "add.product_refer")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductReferAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productreferview[/{id}]", [PermissionMiddleware::class], "view.product_refer")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductReferView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productreferedit[/{id}]", [PermissionMiddleware::class], "edit.product_refer")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductReferEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/productreferdelete[/{id}]", [PermissionMiddleware::class], "delete.product_refer")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductReferDelete");
    }
}
