<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductNotifyController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productnotifylist[/{id}]", [PermissionMiddleware::class], "list.product_notify")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductNotifyList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productnotifyadd[/{id}]", [PermissionMiddleware::class], "add.product_notify")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductNotifyAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productnotifyview[/{id}]", [PermissionMiddleware::class], "view.product_notify")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductNotifyView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productnotifyedit[/{id}]", [PermissionMiddleware::class], "edit.product_notify")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductNotifyEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/productnotifydelete[/{id}]", [PermissionMiddleware::class], "delete.product_notify")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductNotifyDelete");
    }
}
