<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductGroupController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productgrouplist[/{id}]", [PermissionMiddleware::class], "list.product_group")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductGroupList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productgroupadd[/{id}]", [PermissionMiddleware::class], "add.product_group")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductGroupAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productgroupview[/{id}]", [PermissionMiddleware::class], "view.product_group")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductGroupView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productgroupedit[/{id}]", [PermissionMiddleware::class], "edit.product_group")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductGroupEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/productgroupsearch", [PermissionMiddleware::class], "search.product_group")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductGroupSearch");
    }
}
