<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductGController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productglist[/{id}]", [PermissionMiddleware::class], "list.product_g")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductGList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productgadd[/{id}]", [PermissionMiddleware::class], "add.product_g")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductGAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productgedit[/{id}]", [PermissionMiddleware::class], "edit.product_g")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductGEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/productgsearch", [PermissionMiddleware::class], "search.product_g")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductGSearch");
    }
}
