<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductFController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productflist[/{id}]", [PermissionMiddleware::class], "list.product_f")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductFList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productfadd[/{id}]", [PermissionMiddleware::class], "add.product_f")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductFAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productfedit[/{id}]", [PermissionMiddleware::class], "edit.product_f")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductFEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/productfsearch", [PermissionMiddleware::class], "search.product_f")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductFSearch");
    }
}
