<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productlist[/{id}]", [PermissionMiddleware::class], "list.product")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productadd[/{id}]", [PermissionMiddleware::class], "add.product")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/productaddopt", [PermissionMiddleware::class], "addopt.product")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductAddopt", null, false);
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productedit[/{id}]", [PermissionMiddleware::class], "edit.product")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/productsearch", [PermissionMiddleware::class], "search.product")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductSearch");
    }
}
