<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductCategoryController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productcategorylist[/{id}]", [PermissionMiddleware::class], "list.product_category")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCategoryList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productcategoryadd[/{id}]", [PermissionMiddleware::class], "add.product_category")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCategoryAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productcategoryview[/{id}]", [PermissionMiddleware::class], "view.product_category")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCategoryView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productcategoryedit[/{id}]", [PermissionMiddleware::class], "edit.product_category")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCategoryEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/productcategorydelete[/{id}]", [PermissionMiddleware::class], "delete.product_category")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCategoryDelete");
    }
}
