<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductCartSSampleController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productcartssamplelist[/{id}]", [PermissionMiddleware::class], "list.product_cart_s_sample")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartSSampleList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productcartssampleadd[/{id}]", [PermissionMiddleware::class], "add.product_cart_s_sample")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartSSampleAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productcartssampleview[/{id}]", [PermissionMiddleware::class], "view.product_cart_s_sample")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartSSampleView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productcartssampleedit[/{id}]", [PermissionMiddleware::class], "edit.product_cart_s_sample")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartSSampleEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/productcartssampledelete[/{id}]", [PermissionMiddleware::class], "delete.product_cart_s_sample")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartSSampleDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/productcartssamplesearch", [PermissionMiddleware::class], "search.product_cart_s_sample")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartSSampleSearch");
    }
}
