<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductCartSController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productcartslist[/{id}]", [PermissionMiddleware::class], "list.product_cart_s")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartSList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productcartsadd[/{id}]", [PermissionMiddleware::class], "add.product_cart_s")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartSAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productcartsview[/{id}]", [PermissionMiddleware::class], "view.product_cart_s")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartSView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productcartsedit[/{id}]", [PermissionMiddleware::class], "edit.product_cart_s")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartSEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/productcartsupdate", [PermissionMiddleware::class], "update.product_cart_s")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartSUpdate");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/productcartsdelete[/{id}]", [PermissionMiddleware::class], "delete.product_cart_s")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartSDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/productcartssearch", [PermissionMiddleware::class], "search.product_cart_s")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartSSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/productcartspreview", [PermissionMiddleware::class], "preview.product_cart_s")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartSPreview", null, false);
    }
}
