<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductCartBWbcController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productcartbwbclist[/{id}]", [PermissionMiddleware::class], "list.product_cart_b_wbc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBWbcList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productcartbwbcadd[/{id}]", [PermissionMiddleware::class], "add.product_cart_b_wbc")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBWbcAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productcartbwbcview[/{id}]", [PermissionMiddleware::class], "view.product_cart_b_wbc")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBWbcView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productcartbwbcedit[/{id}]", [PermissionMiddleware::class], "edit.product_cart_b_wbc")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBWbcEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/productcartbwbcdelete[/{id}]", [PermissionMiddleware::class], "delete.product_cart_b_wbc")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBWbcDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/productcartbwbcsearch", [PermissionMiddleware::class], "search.product_cart_b_wbc")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBWbcSearch");
    }
}
