<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductCartBSampleController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productcartbsamplelist[/{id}]", [PermissionMiddleware::class], "list.product_cart_b_sample")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBSampleList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productcartbsampleadd[/{id}]", [PermissionMiddleware::class], "add.product_cart_b_sample")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBSampleAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productcartbsampleview[/{id}]", [PermissionMiddleware::class], "view.product_cart_b_sample")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBSampleView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productcartbsampleedit[/{id}]", [PermissionMiddleware::class], "edit.product_cart_b_sample")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBSampleEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/productcartbsampledelete[/{id}]", [PermissionMiddleware::class], "delete.product_cart_b_sample")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBSampleDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/productcartbsamplesearch", [PermissionMiddleware::class], "search.product_cart_b_sample")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBSampleSearch");
    }
}
