<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductCartBController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productcartblist[/{id}]", [PermissionMiddleware::class], "list.product_cart_b")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productcartbadd[/{id}]", [PermissionMiddleware::class], "add.product_cart_b")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productcartbview[/{id}]", [PermissionMiddleware::class], "view.product_cart_b")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productcartbedit[/{id}]", [PermissionMiddleware::class], "edit.product_cart_b")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/productcartbdelete[/{id}]", [PermissionMiddleware::class], "delete.product_cart_b")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/productcartbsearch", [PermissionMiddleware::class], "search.product_cart_b")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/productcartbquery", [PermissionMiddleware::class], "query.product_cart_b")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductCartBSearch", "ProductCartBQuery");
    }
}
