<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProductAskpriceController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/productaskpricelist[/{id}]", [PermissionMiddleware::class], "list.product_askprice")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductAskpriceList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/productaskpriceadd[/{id}]", [PermissionMiddleware::class], "add.product_askprice")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductAskpriceAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/productaskpriceview[/{id}]", [PermissionMiddleware::class], "view.product_askprice")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductAskpriceView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/productaskpriceedit[/{id}]", [PermissionMiddleware::class], "edit.product_askprice")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductAskpriceEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/productaskpricedelete[/{id}]", [PermissionMiddleware::class], "delete.product_askprice")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProductAskpriceDelete");
    }
}
