<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProdPlanLogController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/prodplanloglist[/{id}]", [PermissionMiddleware::class], "list.prod_plan_log")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProdPlanLogList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/prodplanlogadd[/{id}]", [PermissionMiddleware::class], "add.prod_plan_log")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProdPlanLogAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/prodplanlogview[/{id}]", [PermissionMiddleware::class], "view.prod_plan_log")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProdPlanLogView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/prodplanlogedit[/{id}]", [PermissionMiddleware::class], "edit.prod_plan_log")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProdPlanLogEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/prodplanlogdelete[/{id}]", [PermissionMiddleware::class], "delete.prod_plan_log")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProdPlanLogDelete");
    }
}
