<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProcessYeildController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/processyeildlist", [PermissionMiddleware::class], "list.process_yeild")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessYeildList");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/processyeildsearch", [PermissionMiddleware::class], "search.process_yeild")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessYeildSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/processyeildquery", [PermissionMiddleware::class], "query.process_yeild")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessYeildSearch", "ProcessYeildQuery");
    }
}
