<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProcessWbcWppController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/processwbcwpplist[/{id}]", [PermissionMiddleware::class], "list.process_wbc_wpp")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessWbcWppList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/processwbcwppadd[/{id}]", [PermissionMiddleware::class], "add.process_wbc_wpp")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessWbcWppAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/processwbcwppview[/{id}]", [PermissionMiddleware::class], "view.process_wbc_wpp")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessWbcWppView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/processwbcwppedit[/{id}]", [PermissionMiddleware::class], "edit.process_wbc_wpp")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessWbcWppEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/processwbcwppdelete[/{id}]", [PermissionMiddleware::class], "delete.process_wbc_wpp")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessWbcWppDelete");
    }
}
