<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProcessTypeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/processtypelist[/{id}]", [PermissionMiddleware::class], "list.process_type")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTypeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/processtypeadd[/{id}]", [PermissionMiddleware::class], "add.process_type")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTypeAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/processtypeaddopt", [PermissionMiddleware::class], "addopt.process_type")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTypeAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/processtypeview[/{id}]", [PermissionMiddleware::class], "view.process_type")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTypeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/processtypeedit[/{id}]", [PermissionMiddleware::class], "edit.process_type")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTypeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/processtypedelete[/{id}]", [PermissionMiddleware::class], "delete.process_type")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTypeDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/processtypesearch", [PermissionMiddleware::class], "search.process_type")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTypeSearch");
    }
}
