<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProcessTableOldController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/processtableoldlist[/{id}]", [PermissionMiddleware::class], "list.process_table_old")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTableOldList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/processtableoldadd[/{id}]", [PermissionMiddleware::class], "add.process_table_old")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTableOldAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/processtableoldview[/{id}]", [PermissionMiddleware::class], "view.process_table_old")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTableOldView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/processtableoldedit[/{id}]", [PermissionMiddleware::class], "edit.process_table_old")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTableOldEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/processtableoldsearch", [PermissionMiddleware::class], "search.process_table_old")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTableOldSearch");
    }
}
