<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProcessTableHsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/processtablehslist[/{id}]", [PermissionMiddleware::class], "list.process_table_hs")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTableHsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/processtablehsadd[/{id}]", [PermissionMiddleware::class], "add.process_table_hs")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTableHsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/processtablehsview[/{id}]", [PermissionMiddleware::class], "view.process_table_hs")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTableHsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/processtablehsedit[/{id}]", [PermissionMiddleware::class], "edit.process_table_hs")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTableHsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/processtablehsdelete[/{id}]", [PermissionMiddleware::class], "delete.process_table_hs")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTableHsDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/processtablehssearch", [PermissionMiddleware::class], "search.process_table_hs")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTableHsSearch");
    }
}
