<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProcessTableController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/processtablelist[/{id}]", [PermissionMiddleware::class], "list.process_table")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTableList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/processtableadd[/{id}]", [PermissionMiddleware::class], "add.process_table")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTableAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/processtableview[/{id}]", [PermissionMiddleware::class], "view.process_table")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTableView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/processtableedit[/{id}]", [PermissionMiddleware::class], "edit.process_table")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTableEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/processtablesearch", [PermissionMiddleware::class], "search.process_table")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessTableSearch");
    }
}
