<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProcessHouseController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/processhouselist[/{id}]", [PermissionMiddleware::class], "list.process_house")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessHouseList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/processhouseadd[/{id}]", [PermissionMiddleware::class], "add.process_house")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessHouseAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/processhouseview[/{id}]", [PermissionMiddleware::class], "view.process_house")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessHouseView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/processhouseedit[/{id}]", [PermissionMiddleware::class], "edit.process_house")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessHouseEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/processhousedelete[/{id}]", [PermissionMiddleware::class], "delete.process_house")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessHouseDelete");
    }
}
