<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProcessController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/processlist[/{id}]", [PermissionMiddleware::class], "list.process")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/processadd[/{id}]", [PermissionMiddleware::class], "add.process")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/processview[/{id}]", [PermissionMiddleware::class], "view.process")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/processsearch", [PermissionMiddleware::class], "search.process")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessSearch");
    }
}
