<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProcessActionSingleOldController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/processactionsingleoldlist[/{id}]", [PermissionMiddleware::class], "list.process_action_single_old")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionSingleOldList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/processactionsingleoldview[/{id}]", [PermissionMiddleware::class], "view.process_action_single_old")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionSingleOldView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/processactionsingleoldsearch", [PermissionMiddleware::class], "search.process_action_single_old")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionSingleOldSearch");
    }
}
