<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProcessActionSingleController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/processactionsinglelist[/{id}]", [PermissionMiddleware::class], "list.process_action_single")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionSingleList");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/processactionsingledelete[/{id}]", [PermissionMiddleware::class], "delete.process_action_single")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionSingleDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/processactionsinglesearch", [PermissionMiddleware::class], "search.process_action_single")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionSingleSearch");
    }
}
