<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProcessActionPaymentPeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/processactionpaymentpelist", [PermissionMiddleware::class], "list.process_action_payment_pe")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionPaymentPeList");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/processactionpaymentpesearch", [PermissionMiddleware::class], "search.process_action_payment_pe")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionPaymentPeSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/processactionpaymentpequery", [PermissionMiddleware::class], "query.process_action_payment_pe")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionPaymentPeSearch", "ProcessActionPaymentPeQuery");
    }
}
