<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProcessActionMaterialController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/processactionmateriallist[/{id}]", [PermissionMiddleware::class], "list.process_action_material")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionMaterialList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/processactionmaterialadd[/{id}]", [PermissionMiddleware::class], "add.process_action_material")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionMaterialAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/processactionmaterialview[/{id}]", [PermissionMiddleware::class], "view.process_action_material")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionMaterialView");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/processactionmaterialdelete[/{id}]", [PermissionMiddleware::class], "delete.process_action_material")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionMaterialDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/processactionmaterialsearch", [PermissionMiddleware::class], "search.process_action_material")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionMaterialSearch");
    }
}
