<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ProcessActionController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/processactionlist[/{id}]", [PermissionMiddleware::class], "list.process_action")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/processactionadd[/{id}]", [PermissionMiddleware::class], "add.process_action")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/processactionview[/{id}]", [PermissionMiddleware::class], "view.process_action")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/processactionsearch", [PermissionMiddleware::class], "search.process_action")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProcessActionSearch");
    }
}
