<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PortalVersionController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/portalversionlist[/{id}]", [PermissionMiddleware::class], "list.portal_version")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalVersionList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/portalversionadd[/{id}]", [PermissionMiddleware::class], "add.portal_version")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalVersionAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/portalversionview[/{id}]", [PermissionMiddleware::class], "view.portal_version")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalVersionView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/portalversionedit[/{id}]", [PermissionMiddleware::class], "edit.portal_version")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalVersionEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/portalversiondelete[/{id}]", [PermissionMiddleware::class], "delete.portal_version")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalVersionDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/portalversionsearch", [PermissionMiddleware::class], "search.portal_version")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalVersionSearch");
    }
}
