<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PortalUpdatesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/portalupdateslist[/{id}]", [PermissionMiddleware::class], "list.portal_updates")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalUpdatesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/portalupdatesadd[/{id}]", [PermissionMiddleware::class], "add.portal_updates")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalUpdatesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/portalupdatesview[/{id}]", [PermissionMiddleware::class], "view.portal_updates")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalUpdatesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/portalupdatesedit[/{id}]", [PermissionMiddleware::class], "edit.portal_updates")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalUpdatesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/portalupdatesdelete[/{id}]", [PermissionMiddleware::class], "delete.portal_updates")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalUpdatesDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/portalupdatessearch", [PermissionMiddleware::class], "search.portal_updates")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalUpdatesSearch");
    }
}
