<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PortalSetupController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/portalsetuplist[/{id}]", [PermissionMiddleware::class], "list.portal_setup")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalSetupList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/portalsetupview[/{id}]", [PermissionMiddleware::class], "view.portal_setup")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalSetupView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/portalsetupedit[/{id}]", [PermissionMiddleware::class], "edit.portal_setup")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalSetupEdit");
    }
}
