<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PortalListController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/portallistlist[/{id}]", [PermissionMiddleware::class], "list.portal_list")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalListList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/portallistadd[/{id}]", [PermissionMiddleware::class], "add.portal_list")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalListAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/portallistview[/{id}]", [PermissionMiddleware::class], "view.portal_list")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalListView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/portallistedit[/{id}]", [PermissionMiddleware::class], "edit.portal_list")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalListEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/portallistdelete[/{id}]", [PermissionMiddleware::class], "delete.portal_list")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalListDelete");
    }
}
