<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PortalInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/portalinfolist[/{id}]", [PermissionMiddleware::class], "list.portal_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalInfoList");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/portalinfoedit[/{id}]", [PermissionMiddleware::class], "edit.portal_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalInfoEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/portalinfosearch", [PermissionMiddleware::class], "search.portal_info")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalInfoSearch");
    }
}
