<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PortalImageSizeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/portalimagesizelist[/{id}]", [PermissionMiddleware::class], "list.portal_image_size")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalImageSizeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/portalimagesizeadd[/{id}]", [PermissionMiddleware::class], "add.portal_image_size")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalImageSizeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/portalimagesizeview[/{id}]", [PermissionMiddleware::class], "view.portal_image_size")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalImageSizeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/portalimagesizeedit[/{id}]", [PermissionMiddleware::class], "edit.portal_image_size")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalImageSizeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/portalimagesizedelete[/{id}]", [PermissionMiddleware::class], "delete.portal_image_size")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortalImageSizeDelete");
    }
}
