<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PortController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/portlist[/{id}]", [PermissionMiddleware::class], "list.port")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/portadd[/{id}]", [PermissionMiddleware::class], "add.port")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/portaddopt", [PermissionMiddleware::class], "addopt.port")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/portview[/{id}]", [PermissionMiddleware::class], "view.port")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/portedit[/{id}]", [PermissionMiddleware::class], "edit.port")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/portdelete[/{id}]", [PermissionMiddleware::class], "delete.port")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/portsearch", [PermissionMiddleware::class], "search.port")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PortSearch");
    }
}
