<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PoStatusController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/postatuslist[/{id}]", [PermissionMiddleware::class], "list.po_status")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoStatusList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/postatusadd[/{id}]", [PermissionMiddleware::class], "add.po_status")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoStatusAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/postatusview[/{id}]", [PermissionMiddleware::class], "view.po_status")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoStatusView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/postatusedit[/{id}]", [PermissionMiddleware::class], "edit.po_status")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoStatusEdit");
    }
}
