<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PoSetupController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/posetuplist[/{id}]", [PermissionMiddleware::class], "list.po_setup")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoSetupList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/posetupadd[/{id}]", [PermissionMiddleware::class], "add.po_setup")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoSetupAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/posetupview[/{id}]", [PermissionMiddleware::class], "view.po_setup")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoSetupView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/posetupedit[/{id}]", [PermissionMiddleware::class], "edit.po_setup")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoSetupEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/posetupdelete[/{id}]", [PermissionMiddleware::class], "delete.po_setup")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoSetupDelete");
    }
}
