<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PoSPendingPRemarksController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/pospendingpremarkslist[/{id}]", [PermissionMiddleware::class], "list.po_s_pending_p_remarks")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoSPendingPRemarksList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/pospendingpremarksview[/{id}]", [PermissionMiddleware::class], "view.po_s_pending_p_remarks")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoSPendingPRemarksView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/pospendingpremarksedit[/{id}]", [PermissionMiddleware::class], "edit.po_s_pending_p_remarks")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoSPendingPRemarksEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/pospendingpremarkssearch", [PermissionMiddleware::class], "search.po_s_pending_p_remarks")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoSPendingPRemarksSearch");
    }
}
