<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PoSAuthController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/posauthlist[/{id}]", [PermissionMiddleware::class], "list.po_s_auth")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoSAuthList");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/posauthsearch", [PermissionMiddleware::class], "search.po_s_auth")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoSAuthSearch");
    }
}
