<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PoPendingWbcController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/popendingwbclist[/{id}]", [PermissionMiddleware::class], "list.po_pending_wbc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoPendingWbcList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/popendingwbcview[/{id}]", [PermissionMiddleware::class], "view.po_pending_wbc")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoPendingWbcView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/popendingwbcsearch", [PermissionMiddleware::class], "search.po_pending_wbc")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoPendingWbcSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/popendingwbcquery", [PermissionMiddleware::class], "query.po_pending_wbc")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PoPendingWbcSearch", "PoPendingWbcQuery");
    }
}
